#	vzdalenost car na koberci je presne 10 centimetru
d <- 10
#	rozmer koberce (v centimetrech)
M <- 100
#	delka jehly
l <- 7
#	pocet hodu
N <- 1e3

par (mfrow = c(1,1), mar = c (1,1,2,1))
plot (c(0,M), c(0,M), type = "n")
for (y in seq (0, M, by = d)) {
	abline (h = y, col = "sienna", lty = 2)
	}

Sx <- runif (N, min = 0, max = M) 
Sy <- runif (N, min = 0, max = M) 
U <- runif (N, min = 0, max = pi) 

Ax <- Sx + l/2 * cos (U)
Ay <- Sy + l/2 * sin (U)
Bx <- Sx - l/2 * cos (U)
By <- Sy - l/2 * sin (U)

V <- data.frame (cbind (U, Ax, Ay, Bx, By))
names (V)
str (V)
summary (V)

for (i in 1:nrow(V)) {
	lines (c(V$Ax[i], V$Bx[i]), c(V$Ay[i], V$By[i]), col = "steelblue")
	}
V$ok <- abs (trunc (V$By / d) - trunc (V$Ay / d)) > 0
title (main = paste (sum (V$ok), "/", N, "=", sum (V$ok) / N))
